﻿//////////////////////////////////////////////
// Color.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkWinUi
#include "../Dll/DllDefines.h"

/// Class ------------------------------------

namespace nkWinUi
{
	class DLL_WINUI_EXPORT Color final
	{
		public :

			// Constructor, destructor
			Color () noexcept ;
			explicit Color (unsigned char r, unsigned char g, unsigned char b, unsigned char a = 255) noexcept ;
			explicit Color (float r, float g, float b, float a = 1.f) noexcept ;
			explicit Color (double r, double g, double b, double a = 1.0) noexcept ;
			explicit Color (unsigned int r, unsigned int g, unsigned int b, unsigned int a = 255u) noexcept ;
			explicit Color (unsigned long long r, unsigned long long g, unsigned long long b, unsigned long long a = 255ull) noexcept ;
			explicit Color (int r, int g, int b, int a = 255) noexcept ;
			explicit Color (long long r, long long g, long long b, long long a = 255ll) noexcept ;

			// Getters
			float getR () const ;
			float getG () const ;
			float getB () const ;
			float getA () const ;
			unsigned int getR255 () const ;
			unsigned int getG255 () const ;
			unsigned int getB255 () const ;
			unsigned int getA255 () const ;

			// Color manipulations
			// Multiply or divide by factor depending on brightness
			Color getAssociateColor (float factor = 1.5f) const ;
			// Mix with another color
			Color mix (const Color& other, float factor) const ;
			// Layering association
			Color getColorForDepth (unsigned int depth) const ;

			// Operators
			Color operator* (float factor) const ;

		private :

			float _r ;
			float _g ;
			float _b ;
			float _a ;
	} ;
}